<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$host = 'localhost';
$username = 'aigrwnft_db';
$password = 'aigrwnft_db';
$dbname = 'aigrwnft_db';

$conn = new mysqli($host, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$action = $_GET['action'] ?? null;
$uid = $_GET['uid'] ?? null;
$preserve = $_GET['preserve'] ?? null;
$betAmount = $_GET['betAmount'] ?? null;
$gameid = $_GET['game'] ?? null;

if (!$action || $action !== 'subbet') {
    echo json_encode(['error' => 'Invalid action']);
    exit;
}

if (!$uid || $preserve === null || $betAmount === null) {
    echo json_encode(['error' => 'Invalid parameters']);
    exit;
}

$query = 'SELECT money FROM users WHERE phone = ?';
$stmt = $conn->prepare($query);
$stmt->bind_param('s', $uid);
$stmt->execute();
$stmt->bind_result($money);
$stmt->fetch();
$stmt->close();

if ($money === null) {
    echo json_encode(['error' => 'User Not Found']);
    exit;
}

if ($preserve == 0 && $betAmount > 0) {
    $newBalance = $money - $betAmount;
} elseif ($preserve > 0 && $betAmount == 0) {
    $newBalance = $money - $preserve;
} else {
    echo json_encode(['error' => 'Invalid betting conditions']);
    exit;
}

$updateQuery = 'UPDATE users SET money = ? WHERE phone = ?';
$updateStmt = $conn->prepare($updateQuery);
$updateStmt->bind_param('ds', $newBalance, $uid);
$updateStmt->execute();
$updateStmt->close();

function fetchGameName($gameid) {
    $apiUrl = "https://jili.shivwin.in/Web/gamename.php?gameid=" . $gameid;
    $response = file_get_contents($apiUrl);
    $data = json_decode($response, true);
    
    if (isset($data['name']['en-US'])) {
        return $data['name']['en-US'] . " Bet";
    }
    return null;
}

$gamename = fetchGameName($gameid);
if ($gamename) {
    $jili_cmn_id = "JILI-$gameid-" . str_pad(mt_rand(0, 999999999999), 12, '0', STR_PAD_LEFT);
    $currentTime = round(microtime(true) * 1000);

    $insertQuery = 'INSERT INTO Record_api (id_order, phone, game, money, tr_type, status, time) VALUES (?, ?, ?, ?, ?, ?, ?)';
    $insertStmt = $conn->prepare($insertQuery);
    $tr_type = "bet";
    $status = 1;
    $insertStmt->bind_param('sssdsii', $jili_cmn_id, $uid, $gamename, $betAmount, $tr_type, $status, $currentTime);
    $insertStmt->execute();
    $insertStmt->close();
}

echo json_encode(['money' => $newBalance]);

$conn->close();
?>
