<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$host = 'localhost';
$username = 'aigrwnft_db';
$password = 'aigrwnft_db';
$dbname = 'aigrwnft_db';

$conn = new mysqli($host, $username, $password, $dbname);

if ($conn->connect_error) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$action = $_GET['action'] ?? null;
$uid = $_GET['uid'] ?? null;
$betAmount = $_GET['betAmount'] ?? null;
$winloseAmount = $_GET['winloseAmount'] ?? null;
$gameid = $_GET['game'] ?? null;

if (!$action || $action !== 'bet') {
    echo json_encode(['error' => 'Invalid action']);
    exit;
}

if (!$uid || $betAmount === null || $winloseAmount === null) {
    echo json_encode(['error' => 'Invalid parameters']);
    exit;
}

$query = 'SELECT money FROM users WHERE phone = ?';
$stmt = $conn->prepare($query);
$stmt->bind_param('s', $uid);
$stmt->execute();
$stmt->bind_result($money);
$stmt->fetch();
$stmt->close();

if ($money === null) {
    echo json_encode(['error' => 'Not Found']);
    exit;
}

function fetchGameName($gameid, $suffix) {
    $apiUrl = "https://jili.shivwin.in/Web/gamename.php?gameid=" . $gameid;
    $response = file_get_contents($apiUrl);
    $data = json_decode($response, true);
    
    if (isset($data['name']['en-US'])) {
        return $data['name']['en-US'] . " " . $suffix;
    }
    return null;
}

if ($money >= $betAmount) {
    $newBalance = $money - $betAmount + $winloseAmount;
    $updateQuery = 'UPDATE users SET money = ? WHERE phone = ?';
    $updateStmt = $conn->prepare($updateQuery);
    $updateStmt->bind_param('ds', $newBalance, $uid);
    $updateStmt->execute();
    $updateStmt->close();

    $gamenameBet = fetchGameName($gameid, "Bet");
    
    if ($gamenameBet) {
        $jili_cmn_id_bet = "JILI-$gameid-" . str_pad(mt_rand(0, 999999999999), 12, '0', STR_PAD_LEFT);
        $currentTime = round(microtime(true) * 1000);

        $insertQuery = 'INSERT INTO Record_api (id_order, phone, game, money, tr_type, status, time) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $insertStmt = $conn->prepare($insertQuery);
        $tr_type_bet = "bet";
        $status_bet = 1;
        $insertStmt->bind_param('sssdsii', $jili_cmn_id_bet, $uid, $gamenameBet, $betAmount, $tr_type_bet, $status_bet, $currentTime);
        $insertStmt->execute();
    }

    if ($winloseAmount > 0) {
        $gamenameWin = fetchGameName($gameid, "Win");
        
        if ($gamenameWin) {
            $jili_cmn_id_win = "JILI-$gameid-" . str_pad(mt_rand(0, 999999999999), 12, '0', STR_PAD_LEFT);
            $currentTime = round(microtime(true) * 1000);

            $tr_type_win = "win";
            $status_win = 2;
            $insertStmt->bind_param('sssdsii', $jili_cmn_id_win, $uid, $gamenameWin, $winloseAmount, $tr_type_win, $status_win, $currentTime);
            $insertStmt->execute();
        }
    }

    echo json_encode(['money' => $newBalance]);
} else {
    echo json_encode(['error' => 'Not enough balance']);
}

$conn->close();
?>
